/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.util.AECableType;
import appeng.block.networking.EnergyCellBlock;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.util.SettingsFrom;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EnergyCellBlockEntity
extends AENetworkBlockEntity
implements IAEPowerStorage {
    private static final double MAX_STORED = 200000.0;
    private double internalCurrentPower = 0.0;
    private double internalMaxPower = 200000.0;
    private byte currentMeta = (byte)-1;

    public EnergyCellBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IAEPowerStorage.class, this);
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        int value = (Integer)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)EnergyCellBlock.ENERGY_STORAGE);
        this.currentMeta = (byte)value;
        this.updateStateForPowerLevel();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        return (int)Math.floor(4.0 * Mth.m_14008_((double)(fillFactor + 0.01), (double)0.0, (double)1.0));
    }

    private void updateStateForPowerLevel() {
        if (this.notLoaded() || this.m_58901_()) {
            return;
        }
        int storageLevel = EnergyCellBlockEntity.getStorageLevelFromFillFactor(this.internalCurrentPower / this.getInternalMaxPower());
        if (this.currentMeta != storageLevel) {
            this.currentMeta = (byte)storageLevel;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(storageLevel)));
        }
    }

    private void onAmountChanged() {
        this.m_6596_();
        this.updateStateForPowerLevel();
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128347_("internalCurrentPower", this.internalCurrentPower);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.internalCurrentPower = data.m_128459_("internalCurrentPower");
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.internalCurrentPower = input.m_128459_("internalCurrentPower");
        }
    }

    @Override
    public void exportSettings(SettingsFrom from, CompoundTag data, @Nullable Player player) {
        super.exportSettings(from, data, player);
        if (from == SettingsFrom.DISMANTLE_ITEM && this.internalCurrentPower > 1.0E-4) {
            data.m_128347_("internalCurrentPower", this.internalCurrentPower);
            data.m_128347_("internalMaxPower", this.getInternalMaxPower());
        }
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.internalCurrentPower + amt;
            if (fakeBattery > this.getInternalMaxPower()) {
                return fakeBattery - this.getInternalMaxPower();
            }
            return 0.0;
        }
        if (this.internalCurrentPower < 0.01 && amt > 0.01) {
            this.getMainNode().getNode().getGrid().postEvent(new GridPowerStorageStateChanged(this, GridPowerStorageStateChanged.PowerEventType.PROVIDE_POWER));
        }
        this.internalCurrentPower += amt;
        if (this.internalCurrentPower > this.getInternalMaxPower()) {
            amt = this.internalCurrentPower - this.getInternalMaxPower();
            this.internalCurrentPower = this.getInternalMaxPower();
            this.onAmountChanged();
            return amt;
        }
        this.onAmountChanged();
        return 0.0;
    }

    @Override
    public double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public double getAECurrentPower() {
        return this.internalCurrentPower;
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    @Override
    public int getPriority() {
        return 200;
    }

    private double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.internalCurrentPower > amt) {
                return amt;
            }
            return this.internalCurrentPower;
        }
        boolean bl = wasFull = this.internalCurrentPower >= this.getInternalMaxPower() - 0.001;
        if (wasFull && amt > 0.001) {
            this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, GridPowerStorageStateChanged.PowerEventType.REQUEST_POWER)));
        }
        if (this.internalCurrentPower > amt) {
            this.internalCurrentPower -= amt;
            this.onAmountChanged();
            return amt;
        }
        amt = this.internalCurrentPower;
        this.internalCurrentPower = 0.0;
        this.onAmountChanged();
        return amt;
    }

    private double getInternalMaxPower() {
        return this.internalMaxPower;
    }

    public void setInternalMaxPower(double internalMaxPower) {
        this.internalMaxPower = internalMaxPower;
    }
}

